/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ResultEvent;

/**
 * An implementation of {@link EngineResults} using List<{@link ResultEvent}> for results and Map<String, Object> for
 * attributes
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class EngineResultsImpl implements EngineResults {
	
	private List<ResultEvent> results = new ArrayList<ResultEvent>();
	private Map<String, Object> attributes = new HashMap<String, Object>();
	
	@Override
	public void addResult(ResultEvent result) {
		results.add(result);
	}

    /**
     * Return a shallow copy of the list of ResultEvents.
     * @return a shallow copy of all the ResultEvents
     */
	@Override
	public List<ResultEvent> getAllResults() {		
		return new ArrayList<ResultEvent>(results); // shallow copy should be defensive enough
	}

    /**
     * Returns null, unimplemented.
     * @param index of the ResultEvent to return
     * @return null
     *
     * @deprecated use {@link #getAllResults()} instead, this method will be removed in a future version
     */
	@Override
    @Deprecated
	public ResultEvent getResultEvent(int index) {
		return getAllResults().get(index);
	}

	@Override
	public List<ResultEvent> getResultsOfType(String type) {

		ArrayList<ResultEvent> newList = new ArrayList<ResultEvent>();
		if (type == null) return newList;
		for (int i=0; i<results.size(); i++){
			if (type.equalsIgnoreCase(results.get(i).getType())){
				newList.add(results.get(i));
			}
		}
		return newList;
	}
	
	/**
	 * @see org.kuali.rice.krms.api.engine.EngineResults#getAttribute(java.lang.String)
	 */
	@Override
	public Object getAttribute(String key) {
	    return attributes.get(key);
	}
	
	/**
	 * @see org.kuali.rice.krms.api.engine.EngineResults#setAttribute(java.lang.String, java.lang.Object)
	 */
	@Override
	public void setAttribute(String key, Object attr) {
	    attributes.put(key, attr);
	}
	
}
