/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import java.util.Map;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;

/**
 * An implementation of {@link Agenda} that executes over an {@link AgendaTree}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */

public class BasicAgenda implements Agenda {

	private Map<String, String> qualifiers;
	private AgendaTree agendaTree;

    /**
     * Create a BasicAgenda with the given qualifiers and {@link AgendaTree}
     * @param qualifiers to determine if a given {@link ExecutionEnvironment} applies.
     * @param agendaTree {@link AgendaTree} to be executed
     */
	public BasicAgenda(Map<String, String> qualifiers, AgendaTree agendaTree) {
		this.qualifiers = qualifiers;
		this.agendaTree = agendaTree;
	}
	
	@Override
	public void execute(ExecutionEnvironment environment) {
		agendaTree.execute(environment);
	}

	@Override
	public boolean appliesTo(ExecutionEnvironment environment) {

        for (Map.Entry<String, String> agendaQualifier : environment.getSelectionCriteria().getAgendaQualifiers().entrySet()) {
            String agendaQualifierValue = qualifiers.get(agendaQualifier.getKey());
            String environmentQualifierValue = agendaQualifier.getValue();
            if (!environmentQualifierValue.equals(agendaQualifierValue)) {
                return false;
            }
        }
		return true;
	}

}
