/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;

/**
 * A {@link Rule} which executes it's {@link AgendaTree} given a @{link ExecutionEnvironment}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SubAgenda implements Rule {

	private AgendaTree agendaTree;

    /**
     * Create a SubAgenda with the given {@link AgendaTree}
     * @param agendaTree {@link AgendaTree} to create the SubAgenda with.
     */
	public SubAgenda(AgendaTree agendaTree) {
		this.agendaTree = agendaTree;
	}
	
	@Override
	public boolean evaluate(ExecutionEnvironment environment) {
		agendaTree.execute(environment);
		return true;
	}

}
