/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import java.util.Collections;
import java.util.List;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.PropositionResult;

/**
 * An implementation of {@link Proposition} which uses a given {@link Expression}&lt;Boolean&gt;
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class ExpressionBasedProposition implements Proposition {

	private final Expression<Boolean> expression;

    /**
     * Create an ExpressionBasedProposition with the given value
     * @param expression {@link Expression} to set the expression to
     */
	public ExpressionBasedProposition(Expression<Boolean> expression) {
		this.expression = expression;
	}
	
	@Override
	public PropositionResult evaluate(ExecutionEnvironment environment) {
		return new PropositionResult(expression.invoke(environment).booleanValue());
	}


    @Override
    public List<Proposition> getChildren() {
        return Collections.emptyList();
    }
    
    @Override
    public boolean isCompound() {
        return false;
    }
}
