/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolutionEngine;
import org.kuali.rice.krms.api.engine.TermResolutionException;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.framework.engine.EngineResultsImpl;
import org.kuali.rice.krms.framework.engine.TermResolutionEngineImpl;

public final class BasicExecutionEnvironment
implements ExecutionEnvironment {
    private final SelectionCriteria selectionCriteria;
    private final Map<Term, Object> facts;
    private final ExecutionOptions executionOptions;
    private final EngineResults engineResults;
    private final TermResolutionEngine termResolutionEngine;
    private Map<Object, Set<Term>> termPropositionMap;

    public BasicExecutionEnvironment(SelectionCriteria selectionCriteria, Map<Term, Object> facts, ExecutionOptions executionOptions, TermResolutionEngine termResolutionEngine) {
        if (selectionCriteria == null) {
            throw new IllegalArgumentException("Selection criteria must not be null.");
        }
        if (facts == null) {
            throw new IllegalArgumentException("Facts must not be null.");
        }
        this.selectionCriteria = selectionCriteria;
        this.executionOptions = new ExecutionOptions(executionOptions);
        this.engineResults = new EngineResultsImpl();
        this.termResolutionEngine = new TermResolutionEngineImpl();
        this.facts = new HashMap<Term, Object>(facts.size());
        this.facts.putAll(facts);
        for (Map.Entry<Term, Object> factsEntry : facts.entrySet()) {
            this.termResolutionEngine.addTermValue(factsEntry.getKey(), factsEntry.getValue());
        }
    }

    public SelectionCriteria getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public Map<Term, Object> getFacts() {
        return Collections.unmodifiableMap(this.facts);
    }

    public void addTermResolver(TermResolver<?> termResolver) {
        this.termResolutionEngine.addTermResolver(termResolver);
    }

    public <T> T resolveTerm(Term term, Object caller) throws TermResolutionException {
        Object value = this.termResolutionEngine.resolveTerm(term);
        if (caller != null) {
            if (this.termPropositionMap == null) {
                this.termPropositionMap = new HashMap<Object, Set<Term>>();
            }
            if (this.termPropositionMap.containsKey(caller)) {
                this.termPropositionMap.get(caller).add(term);
            } else {
                this.termPropositionMap.put(caller, new HashSet());
                this.termPropositionMap.get(caller).add(term);
            }
        }
        this.publishFact(term, value);
        return (T)value;
    }

    public Set<Term> getTermsForCaller(Object caller) {
        return this.termPropositionMap.get(caller);
    }

    public boolean publishFact(Term factName, Object factValue) {
        if (this.facts.containsKey(factName) && ObjectUtils.equals((Object)this.facts.get(factName), (Object)factValue)) {
            return false;
        }
        this.facts.put(factName, factValue);
        this.termResolutionEngine.addTermValue(factName, factValue);
        return true;
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    public EngineResults getEngineResults() {
        return this.engineResults;
    }
}

