/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.type;

import java.util.HashSet;
import java.util.Set;
import org.kuali.rice.core.api.mo.common.Coded;

public enum ValidationActionType implements Coded
{
    WARNING("W"),
    ERROR("E");

    private final String code;
    public static final Set<String> VALID_TYPE_CODES;

    private ValidationActionType(String typeCode) {
        this.code = typeCode;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static ValidationActionType fromString(String s) {
        for (ValidationActionType type : ValidationActionType.values()) {
            if (!type.toString().equals(s.toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public static ValidationActionType fromCode(String code) {
        if (code == null) {
            return null;
        }
        for (ValidationActionType type : ValidationActionType.values()) {
            if (!type.code.equals(code)) continue;
            return type;
        }
        throw new IllegalArgumentException("Failed to locate the ValidationActionType with the given code: " + code);
    }

    public String getCode() {
        return this.code;
    }

    static {
        VALID_TYPE_CODES = new HashSet<String>();
        for (ValidationActionType type : ValidationActionType.values()) {
            VALID_TYPE_CODES.add(type.getCode());
        }
    }
}

