/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;

/**
 * Binary Operator implementation of Expression&lt;Boolean&gt;
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class BinaryOperatorExpression implements Expression<Boolean> {

	private final ComparisonOperator operator;
	private final Expression<? extends Object> lhs;
	private final Expression<? extends Object> rhs;

    /**
     * Create a BinaryOperatorExpression with the given values
     * @param operator {@link ComparisonOperator}
     * @param lhs left hand side Expression
     * @param rhs right hand side Expression
     */
	public BinaryOperatorExpression(ComparisonOperator operator, Expression<? extends Object> lhs, Expression<? extends Object> rhs) {
		this.operator = operator;
		this.lhs = lhs;
		this.rhs = rhs;
	}

    @Override
	public Boolean invoke(ExecutionEnvironment environment) {
		Object lhsValue = lhs.invoke(environment);
		Object rhsValue = rhs.invoke(environment);
		return operator.compare(lhsValue, rhsValue);
	}
	
}
