/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;

/**
 * The {@link Expression} used in Construction will be returned when invoked with any given {@link ExecutionEnvironment}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
public final class ConstantExpression<T> implements Expression<T> {

	private final T value;

    /**
     * Create a ConstantExpression with the given value
     * @param value to set the value to
     */
	public ConstantExpression(T value) {
		this.value = value;
	}

	@Override
	public T invoke(ExecutionEnvironment environment) {
		return value;
	}

}
