/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;

/**
 * Interface for implementing Expressions, invoked on a {@link ExecutionEnvironment}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface Expression<T> {

    /**
     * Invoke on the given {@link ExecutionEnvironment}.
     * @param environment {@link ExecutionEnvironment} to invoke on.
     * @return T
     */
	T invoke(ExecutionEnvironment environment);
	
}
