/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository;

import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krms.api.repository.BaseAttributeContract;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import java.io.Serializable;

/**
 * This class contains the common elements of a KRMS attribute.
 * <p>
 * Attributes provide a way to attach custom data to an entity based on that entity's type.
 * Rules, Actions, Contexts, Agendas and Term Resolvers have their own specific
 * attribute types. This class contains their common fields.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@MappedSuperclass
public abstract class BaseAttributeBo implements BaseAttributeContract, Versioned, Serializable {

    private static final long serialVersionUID = 3820684124163057591L;
    @Column(name="ATTR_VAL")
    private String value;

    @Version
    @Column(name="VER_NBR", length=8)
    protected Long versionNumber;

    @Override
    public String getAttributeDefinitionId() {
        if (getAttributeDefinition() != null) {
            return getAttributeDefinition().getId();
        }

        return null;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Long getVersionNumber() {
        return versionNumber;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }
}
