/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository;

import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krms.api.repository.category.CategoryDefinition;
import org.kuali.rice.krms.api.repository.category.CategoryDefinitionContract;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Entity
@Table(name = "KRMS_CTGRY_T")
public class CategoryBo implements CategoryDefinitionContract, Versioned, Serializable {

    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRMS_CTGRY_S")
    @GeneratedValue(generator = "KRMS_CTGRY_S")
    @Id
    @Column(name = "CTGRY_ID")
    private String id;

    @Column(name = "NM")
    private String name;

    @Column(name = "NMSPC_CD")
    private String namespace;

    @Version
    @Column(name="VER_NBR", length=8)
    protected Long versionNumber;

    /**
     * Converts a mutable bo to it's immutable counterpart
     *
     * @param bo the mutable business object
     * @return the immutable object
     */
    public static CategoryDefinition to(CategoryBo bo) {
        if (bo == null) {
            return null;
        }

        return CategoryDefinition.Builder.create(bo).build();
    }

    /**
     * Converts a list of mutable bos to it's immutable counterpart
     *
     * @param bos the list of mutable business objects
     * @return and immutable list containing the immutable objects
     */
    public static List<CategoryDefinition> to(List<CategoryBo> bos) {
        if (bos == null) {
            return null;
        }

        List<CategoryDefinition> categories = new ArrayList<CategoryDefinition>();

        for (CategoryBo p : bos) {
            categories.add(CategoryDefinition.Builder.create(p).build());
        }

        return Collections.unmodifiableList(categories);
    }

    /**
     * Converts a immutable object to it's mutable bo counterpart
     *
     * @param im immutable object
     * @return the mutable bo
     */
    public static CategoryBo from(CategoryDefinition im) {
        if (im == null) {
            return null;
        }

        CategoryBo bo = new CategoryBo();
        bo.id = im.getId();
        bo.name = im.getName();
        bo.namespace = im.getNamespace();
        bo.setVersionNumber(im.getVersionNumber());

        return bo;
    }

    public static List<CategoryBo> from(List<CategoryDefinition> ims) {
        if (ims == null) {
            return null;
        }

        List<CategoryBo> bos = new ArrayList<CategoryBo>();

        for (CategoryDefinition im : ims) {
            CategoryBo bo = CategoryBo.from(im);
            ((ArrayList<CategoryBo>) bos).add(bo);
        }

        return Collections.unmodifiableList(bos);
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public Long getVersionNumber() {
        return versionNumber;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }
}
