/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.ui;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.impl.repository.CategoryBo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Helper class that returns all category types that are valid for the given context.
 */
public class CategoryValuesFinder extends UifKeyValuesFinderBase {

    private boolean blankOption;

    /**
     * @return the blankOption
     */
    public boolean isBlankOption() {
        return this.blankOption;
    }

    /**
     * @param blankOption the blankOption to set
     */
    public void setBlankOption(boolean blankOption) {
        this.blankOption = blankOption;
    }

    @Override
    public List<KeyValue> getKeyValues(ViewModel model) {
        List<KeyValue> keyValues = new ArrayList<KeyValue>();

        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm) model;
        AgendaEditor agendaEditor = ((AgendaEditor) maintenanceForm.getDocument().getNewMaintainableObject().getDataObject());

        // if we have an agenda w/ a selected context
        if (agendaEditor.getAgenda() != null && StringUtils.isNotBlank(agendaEditor.getAgenda().getContextId())) {

            // key off the namespace

            String namespace = agendaEditor.getNamespace();

            if(blankOption){
                keyValues.add(new ConcreteKeyValue("", ""));
            }

            QueryByCriteria.Builder criteriaBuilder = QueryByCriteria.Builder.forAttribute("namespace", namespace);
            criteriaBuilder.setOrderByAscending("name");

            QueryResults<CategoryBo> categoryResults =
                    KRADServiceLocator.getDataObjectService().findMatching(CategoryBo.class, criteriaBuilder.build());
            List<CategoryBo> categories = categoryResults.getResults();

            for (CategoryBo category : categories) {
                keyValues.add(new ConcreteKeyValue(category.getId(), category.getName()));
            }
        }

        return keyValues;
    }
}
