/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.ui;

import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;

/**
 * data class for agenda tree {@link Node}s containing agenda items 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class AgendaTreeRuleNode extends AgendaTreeNode {

    private static final long serialVersionUID = 8348548494907941273L;

    private AgendaItemBo agendaItemLine;

    // needed for agenda inquiry
    public AgendaTreeRuleNode() {
    }

    public AgendaTreeRuleNode(AgendaItemBo agendaItem) {
        this.agendaItemLine = agendaItem;
    }
    
    /**
     * @return the agendaItem
     */
    public AgendaItemBo getAgendaItemLine() {
        return this.agendaItemLine;
    }
    
    /**
     * @param agendaItem the agendaItem to set
     */
    public void setAgendaItemLine(AgendaItemBo agendaItem) {
        this.agendaItemLine = agendaItem;
    }

}
