/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.type;

import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.framework.type.AgendaTypeService;
import org.kuali.rice.krms.framework.type.FunctionTypeService;
import org.kuali.rice.krms.framework.type.PropositionTypeService;
import org.kuali.rice.krms.framework.type.RuleTypeService;
import org.kuali.rice.krms.framework.type.TermResolverTypeService;

/**
 * The KrmsTypeResolver knows how to resolve the "type services" for the various
 * components of KRMS.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface KrmsTypeResolver {

	PropositionTypeService getPropositionTypeService(PropositionDefinition propositionDefinition);
	
	ActionTypeService getActionTypeService(ActionDefinition actionDefinition);
	
    AgendaTypeService getAgendaTypeService(AgendaDefinition actionDefinition);

    RuleTypeService getRuleTypeService(RuleDefinition ruleDefinition);

	TermResolverTypeService getTermResolverTypeService(TermResolverDefinition termResolverDefintion);
	
	FunctionTypeService getFunctionTypeService(FunctionDefinition functionDefinition);
	
}
