/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.validation;

import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.type.ValidationRuleType;

import java.util.List;

/**
 *
 * A {@link org.kuali.rice.krms.framework.engine.Rule} that executes a {@link org.kuali.rice.krms.framework.engine.Action} when the {@link Proposition} is false,
 * as opposed to {@link BasicRule} which executes its action when the proposition is true.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ValidationRule extends BasicRule {
    private ValidationRuleType type = null;

    /**
     *
     * @param type ValidationRuleType
     * @param name Rule name
     * @param proposition Proposition
     * @param actions Rule Actions
     * @throws IllegalArgumentException if type is null
     */
    public ValidationRule(ValidationRuleType type, String name, Proposition proposition, List<Action> actions) {
        super(name, proposition, actions);
        if (type == null) throw new IllegalArgumentException("type must not be null");
        this.type = type;
    }

    /**
     * Valid Validation Rules execute when the ruleExecutionResult is false.
     * Invalid Validation Rules execute when the ruleExecutionResult is true.
     * @param ruleExecutionResult result of the rules execution
     * @return should the actions be executed
     */
    @Override
    protected boolean shouldExecuteAction(boolean ruleExecutionResult) {
        if (type == null || type.equals(ValidationRuleType.VALID)) {
            return !ruleExecutionResult;
        }
        return ruleExecutionResult;
    }
}
