/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.type;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.type.RuleTypeService;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.type.KrmsTypeServiceBase;

public class RuleTypeServiceBase
extends KrmsTypeServiceBase
implements RuleTypeService {
    public static final RuleTypeService defaultRuleTypeService = new RuleTypeServiceBase();
    private RepositoryToEngineTranslator translator;

    public Rule loadRule(RuleDefinition ruleDefinition) {
        if (ruleDefinition == null) {
            throw new RiceIllegalArgumentException("ruleDefinition must not be null");
        }
        if (ruleDefinition.getAttributes() == null) {
            throw new RiceIllegalArgumentException("ruleDefinition must not be null");
        }
        return new BasicRule(ruleDefinition.getName(), this.getTranslator().translatePropositionDefinition(ruleDefinition.getProposition()), this.getTranslator().translateActionDefinitions(ruleDefinition.getActions()));
    }

    public RepositoryToEngineTranslator getTranslator() {
        if (this.translator == null) {
            this.translator = KrmsRepositoryServiceLocator.getKrmsRepositoryToEngineTranslator();
        }
        return this.translator;
    }

    public void setTranslator(RepositoryToEngineTranslator translator) {
        this.translator = translator;
    }
}

