/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.inquiry.InquiryController;
import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.ui.AgendaEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"krmsAgendaInquiry"})
public class AgendaInquiryController
extends InquiryController {
    private static final RepositoryBoIncrementer ruleIdIncrementer = new RepositoryBoIncrementer("KRMS_RULE_S");

    @RequestMapping(params={"methodToCall=viewRule"})
    public ModelAndView viewRule(UifFormBase form) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        agendaEditor.setAddRuleInProgress(false);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        String selectedItemId = agendaEditor.getSelectedAgendaItemId();
        AgendaItemBo node = this.getAgendaItemById(firstItem, selectedItemId);
        this.setAgendaItemLine(form, node);
        form.getActionParameters().put("navigateToPageId", "AgendaEditorView-ViewRule-Page");
        return super.navigate(form);
    }

    private AgendaEditor getAgendaEditor(UifFormBase form) {
        InquiryForm inquiryForm = (InquiryForm)form;
        return (AgendaEditor)inquiryForm.getDataObject();
    }

    private AgendaItemBo getFirstAgendaItem(AgendaBo agenda) {
        AgendaItemBo firstItem = null;
        if (agenda != null && agenda.getItems() != null) {
            for (AgendaItemBo agendaItem : agenda.getItems()) {
                if (!agenda.getFirstItemId().equals(agendaItem.getId())) continue;
                firstItem = agendaItem;
                break;
            }
        }
        return firstItem;
    }

    private AgendaItemBo getAgendaItemById(AgendaItemBo node, String agendaItemId) {
        if (node == null) {
            throw new IllegalArgumentException("node must be non-null");
        }
        AgendaItemBo result = null;
        if (StringUtils.equals((String)node.getId(), (String)agendaItemId)) {
            result = node;
        } else {
            AgendaItemChildAccessor childAccessor;
            AgendaItemBo child;
            AgendaItemChildAccessor[] agendaItemChildAccessorArray = AgendaItemChildAccessor.linkedNodes;
            int n = agendaItemChildAccessorArray.length;
            for (int i = 0; i < n && ((child = (childAccessor = agendaItemChildAccessorArray[i]).getChild(node)) == null || (result = this.getAgendaItemById(child, agendaItemId)) == null); ++i) {
            }
        }
        return result;
    }

    private void setAgendaItemLine(UifFormBase form, AgendaItemBo agendaItem) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        if (agendaItem == null) {
            RuleBo rule = new RuleBo();
            rule.setId(ruleIdIncrementer.getNewId());
            if (StringUtils.isBlank((String)agendaEditor.getAgenda().getContextId())) {
                rule.setNamespace("");
            } else {
                rule.setNamespace(this.getContextBoService().getContextByContextId(agendaEditor.getAgenda().getContextId()).getNamespace());
            }
            agendaItem = new AgendaItemBo();
            agendaItem.setRule(rule);
            agendaEditor.setAgendaItemLine(agendaItem);
        } else {
            agendaEditor.setAgendaItemLine((AgendaItemBo)KradDataServiceLocator.getDataObjectService().copyInstance((Object)agendaItem, new CopyOption[0]));
        }
        if (agendaItem.getRule().getActions().isEmpty()) {
            ActionBo actionBo = new ActionBo();
            actionBo.setTypeId("");
            actionBo.setNamespace(agendaItem.getRule().getNamespace());
            actionBo.setRule(agendaItem.getRule());
            actionBo.setSequenceNumber(1);
            agendaEditor.setAgendaItemLineRuleAction(actionBo);
        } else {
            agendaEditor.setAgendaItemLineRuleAction(agendaItem.getRule().getActions().get(0));
        }
        agendaEditor.setCustomRuleActionAttributesMap(agendaEditor.getAgendaItemLineRuleAction().getAttributes());
        agendaEditor.setCustomRuleAttributesMap(agendaEditor.getAgendaItemLine().getRule().getAttributes());
    }

    private ContextBoService getContextBoService() {
        return KrmsRepositoryServiceLocator.getContextBoService();
    }

    protected static class AgendaItemChildAccessor {
        private static final AgendaItemChildAccessor whenTrue = new AgendaItemChildAccessor(Child.WHEN_TRUE);
        private static final AgendaItemChildAccessor whenFalse = new AgendaItemChildAccessor(Child.WHEN_FALSE);
        private static final AgendaItemChildAccessor always = new AgendaItemChildAccessor(Child.ALWAYS);
        private static final AgendaItemChildAccessor[] linkedNodes = new AgendaItemChildAccessor[]{whenTrue, whenFalse, always};
        private static final AgendaItemChildAccessor[] children = new AgendaItemChildAccessor[]{whenTrue, whenFalse};
        private final Child whichChild;

        private AgendaItemChildAccessor(Child whichChild) {
            if (whichChild == null) {
                throw new IllegalArgumentException("whichChild must be non-null");
            }
            this.whichChild = whichChild;
        }

        public AgendaItemBo getChild(AgendaItemBo parent) {
            switch (this.whichChild.ordinal()) {
                case 0: {
                    return parent.getWhenTrue();
                }
                case 1: {
                    return parent.getWhenFalse();
                }
                case 2: {
                    return parent.getAlways();
                }
            }
            throw new IllegalStateException();
        }

        public void setChild(AgendaItemBo parent, AgendaItemBo child) {
            switch (this.whichChild.ordinal()) {
                case 0: {
                    parent.setWhenTrue(child);
                    parent.setWhenTrueId(child == null ? null : child.getId());
                    break;
                }
                case 1: {
                    parent.setWhenFalse(child);
                    parent.setWhenFalseId(child == null ? null : child.getId());
                    break;
                }
                case 2: {
                    parent.setAlways(child);
                    parent.setAlwaysId(child == null ? null : child.getId());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private static enum Child {
            WHEN_TRUE,
            WHEN_FALSE,
            ALWAYS;

        }
    }
}

