/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.api.messaging;

import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import java.io.Serializable;
import java.util.Arrays;

/**
 * Encapsulates an asynchronous call to a service.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class AsynchronousCall implements Serializable {

    private static final long serialVersionUID = -1036656564567726747L;

    private final Object[] arguments;

    private final Class<?>[] paramTypes;

    private final ServiceConfiguration serviceConfiguration;

    private final String methodName;

    private boolean ignoreStoreAndForward;

    public AsynchronousCall(Class<?>[] paramTypes, Object[] arguments, ServiceConfiguration serviceConfiguration, String methodName) {
        this.arguments = arguments;
        this.paramTypes = paramTypes;
        this.serviceConfiguration = serviceConfiguration;
        this.methodName = methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isIgnoreStoreAndForward() {
        return this.ignoreStoreAndForward;
    }

    public void setIgnoreStoreAndForward(boolean ignoreStoreAndForward) {
        this.ignoreStoreAndForward = ignoreStoreAndForward;
    }

    @Override
    public String toString() {
        return "AsynchronousCall{" +
                "arguments=" + Arrays.toString(arguments) +
                ", paramTypes=" + Arrays.toString(paramTypes) +
                ", serviceConfiguration=" + serviceConfiguration +
                ", methodName='" + methodName + '\'' +
                ", ignoreStoreAndForward=" + ignoreStoreAndForward +
                '}';
    }
}
