/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.bam;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.core.api.util.reflect.BaseTargetedInvocationHandler;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class BAMClientProxy
extends BaseTargetedInvocationHandler {
    private ServiceConfiguration serviceConfiguration;

    private BAMClientProxy(Object target, ServiceConfiguration serviceConfiguration) {
        super(target);
        this.serviceConfiguration = serviceConfiguration;
    }

    public static boolean isBamSupported() {
        return KSBServiceLocator.getBAMService() != null && Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("bam.enabled")) != false;
    }

    public static Object wrap(Object target, ServiceConfiguration serviceConfiguration) {
        if (!BAMClientProxy.isBamSupported()) {
            return target;
        }
        return Proxy.newProxyInstance(ClassLoaderUtils.getDefaultClassLoader(), ContextClassLoaderProxy.getInterfacesToProxy((Object)target), (InvocationHandler)((Object)new BAMClientProxy(target, serviceConfiguration)));
    }

    protected Object invokeInternal(Object proxyObject, Method method, Object[] arguments) throws Throwable {
        BAMTargetEntry bamTargetEntry = KSBServiceLocator.getBAMService().recordClientInvocation(this.serviceConfiguration, this.getTarget(), method, arguments);
        try {
            return method.invoke(this.getTarget(), arguments);
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            KSBServiceLocator.getBAMService().recordClientInvocationError(throwable, bamTargetEntry);
            throw throwable;
        }
    }
}

