/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.bam.service;

import java.lang.reflect.Method;
import java.util.List;

import javax.xml.namespace.QName;

import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;


/**
 * Service for recording and accessing entries in the BAM.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface BAMService {

	public List<BAMTargetEntry> getCallsForService(QName serviceName);
	public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef);
	public BAMTargetEntry recordClientInvocation(ServiceConfiguration serviceConfiguration, Object target, Method method, Object[] params);
	public BAMTargetEntry recordClientInvocationError(Throwable throwable, BAMTargetEntry bamTargetEntry);
	public BAMTargetEntry recordServerInvocation(Object target, ServiceDefinition serviceDefinition, Method method, Object[] params);
	public BAMTargetEntry recordServerInvocationError(Throwable throwable, BAMTargetEntry bamTargetEntry);
	public void clearBAMTables();
	public List<BAMTargetEntry> getCallsForService(QName serviceName, String methodName);
	public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef, String methodName);
}
