/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.dao;

import org.kuali.rice.ksb.messaging.PersistedMessageBO;

import java.util.List;
import java.util.Map;


public interface MessageQueueDAO {

    void remove(PersistedMessageBO routeQueue);

    PersistedMessageBO save(PersistedMessageBO routeQueue);

    PersistedMessageBO findByRouteQueueId(Long routeQueueId);

    List<PersistedMessageBO> findAll(int maxRows);

    List<PersistedMessageBO> getNextDocuments(Integer maxDocuments);

    /**
     * Finds the persisted messages that match the values passed into the criteriaValues Map, with an EqualTo criteria
     * for each.
     *
     * @param criteriaValues
     *                A Map of Key/Value pairs, where the Key is a string holding the field name, and the Value is a
     *                string holding the value to match.
     * @return A populated (or empty) list containing the results of the search. If no matches are made, an empty list
     *         will be returned.
     */
    List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows);
}
