/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExportManager;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;

/**
 * A {@link HandlerMapping} which handles incoming HTTP requests from the bus.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KSBHttpInvokerHandler extends AbstractHandlerMapping {

    @Override
    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        QName serviceName = getServiceNameFromRequest(request);
        ServiceExportManager serviceExportManager = KSBServiceLocator.getServiceExportManager();
        return serviceExportManager.getService(serviceName);
    }

    public QName getServiceNameFromRequest(HttpServletRequest request) {   	    	
    	return KSBServiceLocator.getServiceExportManager().getServiceName(request.getRequestURL().toString()); 
    }
    
}
