/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.impl.bus.diff;

import java.util.ArrayList;
import java.util.List;

import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.impl.bus.RemoteService;

/**
 * TODO... 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class RemoteServicesDiff {

	private final List<ServiceInfo> newServices;
	private final List<RemoteService> removedServices;
	
	public RemoteServicesDiff(List<ServiceInfo> newServices, List<RemoteService> removedServices) {
		this.newServices = newServices == null ? new ArrayList<ServiceInfo>(0) : newServices;
		this.removedServices = removedServices == null ? new ArrayList<RemoteService>(0) : removedServices;
	}
	
	
	public List<ServiceInfo> getNewServices() {
		return this.newServices;
	}

	public List<RemoteService> getRemovedServices() {
		return this.removedServices;
	} 
	
}
