/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging;

import java.io.IOException;

public class HttpException extends IOException {

	private static final long serialVersionUID = -2660638986164631692L;
	
	private int responseCode;
	
	public HttpException(int responseCode) {
		super();
		this.responseCode = responseCode;
	}

	public HttpException(int responseCode, String message, Throwable cause) {
		super(message, cause);
		this.responseCode = responseCode;
	}

	public HttpException(int responseCode, String arg0) {
		super(arg0);
		this.responseCode = responseCode;
	}

	public int getResponseCode() {
		return this.responseCode;
	}
	
}
