/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

import java.util.ArrayList;
import java.util.List;


public class KSBHttpInvokerProxyFactoryBean extends HttpInvokerProxyFactoryBean {
	private static final Logger LOG = LogManager.getLogger(KSBHttpInvokerProxyFactoryBean.class);

	private Object serviceProxy;

	private JavaServiceConfiguration serviceConfiguration;

	public JavaServiceConfiguration getServiceConfiguration() {
		return this.serviceConfiguration;
	}

	public void setServiceConfiguration(JavaServiceConfiguration serviceConfiguration) {
		this.serviceConfiguration = serviceConfiguration;
	}

	@Override
	public void afterPropertiesSet() {
		ProxyFactory proxyFactory = new ProxyFactory(getServiceInterfaces());
		proxyFactory.addAdvice(this);
		LOG.debug("Http proxying service " + getServiceConfiguration());
		this.serviceProxy = proxyFactory.getProxy();
	}

	@Override
	public Object getObject() {
		return this.serviceProxy;
	}

	@Override
	public Class<?> getObjectType() {
		final Object o = getObject();

		return o != null ? getObject().getClass() : null;
	}

	@Override
	public boolean isSingleton() {
		return false;
	}

	public Class<?>[] getServiceInterfaces() {
		List<Class<?>> serviceInterfaces = new ArrayList<>();
		try {
			for (String interfaceName : getServiceConfiguration().getServiceInterfaces()) {
				Class<?> clazz = Class.forName(interfaceName, true, ClassLoaderUtils.getDefaultClassLoader());
				LOG.debug("Adding service interface '" + clazz + "' to proxy object for service " + getServiceConfiguration());
				serviceInterfaces.add(clazz);
			}
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
		return serviceInterfaces.toArray(new Class[0]);
	}
}
