/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.resourceloader;

import javax.xml.namespace.QName;

import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.kuali.rice.ksb.api.bus.ServiceBus;

/**
 * A simple {@link ResourceLoader} implementation which delegates {@link #getService(QName)}
 * calls to the {@link ServiceBus}. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class ServiceBusResourceLoader extends BaseResourceLoader {

	private final ServiceBus serviceBus;
	
	public ServiceBusResourceLoader(QName resourceLoaderName, ServiceBus serviceBus) {
		super(resourceLoaderName);
		this.serviceBus = serviceBus;
	}
	
	@Override
	public Object getObject(ObjectDefinition definition) {
		// object remoting has been removed!
		return null;
	}

	@Override
	public Object getService(QName serviceName) {
		return serviceBus.getService(serviceName);
	}

}
