/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.serviceconnectors;

import javax.xml.namespace.QName;

import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.bam.BAMClientProxy;


/**
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class BusLocalConnector extends AbstractServiceConnector {

	public BusLocalConnector(final ServiceConfiguration serviceConfiguration) {
		super(serviceConfiguration);
	}

	private Object getServiceProxy(Object service) {
		return BAMClientProxy.wrap(service, getServiceConfiguration());
	}
	
	@Override
    public Object getService() {
		QName serviceName = getServiceConfiguration().getServiceName();
		Endpoint localServiceEndpoint = KsbApiServiceLocator.getServiceBus().getLocalEndpoint(serviceName);
		if (localServiceEndpoint == null) {
			throw new IllegalStateException("Failed to locate a local service with the name: " + serviceName);
		}
	    return getServiceProxy(KsbApiServiceLocator.getServiceBus().getLocalEndpoint(serviceName));
	}
	
}
