/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.serviceconnectors;

import org.apache.http.impl.client.HttpClientBuilder;

/**
 * Interface for customizing HttpClientBuilders.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface HttpClientConfigurer {

    /**
     * Takes in an HttpClientBuilder and customizes it.
     *
     * @param httpClientBuilder the client builder to customize.
     */
    void customizeHttpClient(HttpClientBuilder httpClientBuilder);
}
