/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.threadpool;


import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;

import org.kuali.rice.core.api.lifecycle.Lifecycle;

/**
 * A thread pool which can be used to schedule asynchronous tasks.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface KSBThreadPool extends ExecutorService, Lifecycle {

	public boolean remove(Runnable task);

	public int getActiveCount();

	public void setCorePoolSize(int corePoolSize);

	public int getCorePoolSize();
	
	public int getMaximumPoolSize();

	public void setMaximumPoolSize(int maxPoolSize);

	public int getPoolSize();

	public int getLargestPoolSize();

	public long getKeepAliveTime();

	public long getTaskCount();

	public long getCompletedTaskCount();

	public BlockingQueue getQueue();

	public Object getInstance();
}

