/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security;

import java.security.Signature;
import java.security.cert.Certificate;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.ksb.util.KSBConstants;

/**
 * A DigitalSinger which places the alias and digital signature into the response headers of an HttpServletResponse.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ResponseHeaderDigitalSigner extends AbstractDigitalSigner {

	private String alias;
	private Certificate certificate;
	private HttpServletResponse response;
	
    public ResponseHeaderDigitalSigner(Signature signature, String alias, HttpServletResponse response) {
        super(signature);
        this.alias = alias;
        this.response = response;
    }
    
    public ResponseHeaderDigitalSigner(Signature signature, String alias, Certificate certificate, HttpServletResponse response) {
        this(signature, alias, response);
        this.certificate = certificate;
    }
    
    public ResponseHeaderDigitalSigner(Signature signature, Certificate certificate, HttpServletResponse response) {
        super(signature);
        this.certificate = certificate;
        this.response = response;
    }
    
	@Override
    public void sign() throws Exception {
	    if (StringUtils.isNotBlank(this.alias) ) {
	        this.response.setHeader(KSBConstants.KEYSTORE_ALIAS_HEADER, this.alias);
	    }
	    if (this.certificate != null) {
	        this.response.setHeader(KSBConstants.KEYSTORE_CERTIFICATE_HEADER, getEncodedCertificate(this.certificate));
	    }
	    this.response.setHeader(KSBConstants.DIGITAL_SIGNATURE_HEADER, getEncodedSignature());
	}

}
