/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.quartz;

import java.util.Properties;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class QuartzConfigPropertiesFactoryBean
extends AbstractFactoryBean {
    private static final String QUARTZ_PREFIX = "ksb.org.quartz";
    private static final String QUARTZ_IS_CLUSTERED = "ksb.org.quartz.jobStore.isClustered";
    private static final String QUARTZ_TABLE_PREFIX = "ksb.org.quartz.jobStore.tablePrefix";
    private static final String QUARTZ_DRIVER_DELEGATE_CLASS = "ksb.org.quartz.jobStore.driverDelegateClass";

    protected Object createInstance() throws Exception {
        Properties properties = new Properties();
        Properties configProps = ConfigContext.getCurrentContextConfig().getProperties();
        boolean useQuartzDatabase = Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("useQuartzDatabase"));
        for (Object keyObj : configProps.keySet()) {
            String key;
            if (!(keyObj instanceof String) || !(key = (String)keyObj).startsWith(QUARTZ_PREFIX) || this.propertyShouldBeFiltered(useQuartzDatabase, key)) continue;
            properties.put(key.substring(4), configProps.get(key));
        }
        return properties;
    }

    protected boolean propertyShouldBeFiltered(boolean useQuartzDatabase, String propertyName) {
        return !useQuartzDatabase && (propertyName.startsWith(QUARTZ_TABLE_PREFIX) || propertyName.startsWith(QUARTZ_IS_CLUSTERED) || propertyName.startsWith(QUARTZ_DRIVER_DELEGATE_CLASS));
    }

    public Class getObjectType() {
        return Properties.class;
    }
}

