/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceexporters;

import java.util.HashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.SoapServiceDefinition;
import org.kuali.rice.ksb.impl.cxf.interceptors.ImmutableCollectionsInInterceptor;
import org.kuali.rice.ksb.messaging.serviceexporters.AbstractWebServiceExporter;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExporter;
import org.kuali.rice.ksb.messaging.servicehandlers.BasicAuthenticationHandler;
import org.kuali.rice.ksb.security.soap.CXFWSS4JInInterceptor;
import org.kuali.rice.ksb.security.soap.CXFWSS4JOutInterceptor;

public class SOAPServiceExporter
extends AbstractWebServiceExporter
implements ServiceExporter {
    static final Logger LOG = LogManager.getLogger(SOAPServiceExporter.class);

    public SOAPServiceExporter(SoapServiceDefinition serviceDefinition, Bus cxfBus) {
        super((ServiceDefinition)serviceDefinition, cxfBus);
    }

    @Override
    public void publishService(ServiceDefinition serviceDefinition, Object serviceImpl, String address) {
        ServerFactoryBean svrFactory;
        SoapServiceDefinition soapServiceDefinition = (SoapServiceDefinition)serviceDefinition;
        if (soapServiceDefinition.isJaxWsService()) {
            LOG.info("Creating JaxWsService " + String.valueOf(soapServiceDefinition.getServiceName()));
            svrFactory = new JaxWsServerFactoryBean();
        } else {
            svrFactory = new ServerFactoryBean();
            svrFactory.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
        }
        svrFactory.setBus(this.getCXFBus());
        svrFactory.setServiceName(soapServiceDefinition.getServiceName());
        svrFactory.setAddress(address);
        svrFactory.setPublishedEndpointUrl(soapServiceDefinition.getEndpointUrl().toExternalForm());
        svrFactory.setServiceBean(serviceImpl);
        try {
            svrFactory.setServiceClass(Class.forName(soapServiceDefinition.getServiceInterface()));
        }
        catch (ClassNotFoundException e) {
            throw new RiceRuntimeException("Failed to publish service " + String.valueOf(soapServiceDefinition.getServiceName()) + " because service interface could not be loaded: " + soapServiceDefinition.getServiceInterface(), (Throwable)e);
        }
        if (soapServiceDefinition.isBasicAuthentication()) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("action", "UsernameToken");
            properties.put("passwordType", "PasswordText");
            BasicAuthenticationHandler authenticationHandler = new BasicAuthenticationHandler(soapServiceDefinition.getServiceNameSpaceURI(), serviceDefinition.getServiceName());
            properties.put("passwordCallbackRef", authenticationHandler);
            svrFactory.getInInterceptors().add(new WSS4JInInterceptor(properties));
            svrFactory.getInInterceptors().add(new SAAJInInterceptor());
        } else {
            svrFactory.getInInterceptors().add(new CXFWSS4JInInterceptor(soapServiceDefinition.getBusSecurity()));
            svrFactory.getOutInterceptors().add(new CXFWSS4JOutInterceptor(soapServiceDefinition.getBusSecurity()));
            svrFactory.getInFaultInterceptors().add(new CXFWSS4JInInterceptor(soapServiceDefinition.getBusSecurity()));
            svrFactory.getOutFaultInterceptors().add(new CXFWSS4JOutInterceptor(soapServiceDefinition.getBusSecurity()));
        }
        svrFactory.getInInterceptors().add(new LoggingInInterceptor());
        svrFactory.getInInterceptors().add(new ImmutableCollectionsInInterceptor());
        svrFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        svrFactory.create();
    }
}

