/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security.admin.service;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.List;

import org.kuali.rice.ksb.security.admin.KeyStoreEntryDataContainer;

/**
 * This is an interface for the Java Security Management piece of the KSB module
 * of Rice. It is used for modifying and creating keystores and certificates
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
public interface JavaSecurityManagementService {
 
    public void removeClientCertificate(String alias) throws KeyStoreException;
    
    public KeyStore generateClientKeystore(String alias, String passphrase) throws GeneralSecurityException;
    
    public List<KeyStoreEntryDataContainer> getListOfModuleKeyStoreEntries();
    
    public String getModuleKeyStoreAlias();
    
    public String getModuleKeyStoreLocation();
    
    public String getModuleSignatureAlgorithm();
    
    public Certificate getCertificate(String alias) throws KeyStoreException;
    
    public PrivateKey getModulePrivateKey();
    
    public boolean isAliasInKeystore(String alias) throws KeyStoreException;
    
    public String getCertificateAlias(Certificate certificate) throws KeyStoreException;
    
}
