/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.exceptionhandling;

import org.kuali.rice.ksb.messaging.PersistedMessageBO;

/**
 * A service for putting a document into exception routing.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ExceptionRoutingService {

    void placeInExceptionRouting(Throwable throwable, PersistedMessageBO message) throws Exception;
    void placeInExceptionRoutingLastDitchEffort(Throwable throwable, PersistedMessageBO message) throws Exception;
    void scheduleExecution(Throwable throwable, PersistedMessageBO message, String description) throws Exception;
    
}
