/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security;

import java.security.Signature;

/**
 * Responsible for signing a message.  A reference is provided to the Signature to allow for population
 * of the singnature from message data.  When this population of data is complete, the sign() method
 * will sign the message according to the implementation.
 * <br>
 * Note that the interface itself does not provide any means of retrieving the message being signed.  It
 * is up to the implementing classes to determine what consititutes "signing" of a message.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DigitalSigner {

	/**
	 * Retrieve a reference to Signature which will be used for signing.
	 */
	public Signature getSignature();

	/**
	 * Sign the message using the Signature.  This method will not be called until all of the message data
	 * has been populated into the Signature.  After signing implementations may, for example, place the digital 
	 * signature in a header or perform whatever steps are required to successfully sign the message.
	 */
	public void sign() throws Exception;
	
}
