/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.bam;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * A parameter of a method invocation recorded by the BAM.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name = "KRSB_BAM_PARM_T")
public class BAMParam {

	@Id
	@GeneratedValue(generator = "KRSB_BAM_PARM_S")
    @PortableSequenceGenerator(name = "KRSB_BAM_PARM_S")
    @Column(name = "BAM_PARM_ID")
	private Long bamParamId;

	@ManyToOne(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	@JoinColumn(name = "BAM_ID")
	private BAMTargetEntry bamTargetEntry;

	@Lob
	@Column(name = "PARM")
	private String param;
		
	public BAMTargetEntry getBamTargetEntry() {
		return this.bamTargetEntry;
	}
	public void setBamTargetEntry(BAMTargetEntry bamTargetEntry) {
		this.bamTargetEntry = bamTargetEntry;
	}
	public Long getBamParamId() {
		return this.bamParamId;
	}
	public void setBamParamId(Long bamParamId) {
		this.bamParamId = bamParamId;
	}
	public String getParam() {
		return this.param;
	}
	public void setParam(String paramToString) {
		if (StringUtils.isEmpty(paramToString)) {
			paramToString = "<null>";//oracle blows null constraint on empty strings
		}
		this.param = paramToString;
	}
}
