/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.service;

import java.util.List;
import java.util.Map;

import org.kuali.rice.ksb.messaging.PersistedMessageBO;

/**
 * Service for interfacing with the queue of asynchronous messages.
 * 
 * @see org.kuali.rice.ksb.messaging.PersistedMessageBO
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface MessageQueueService {

    void delete(PersistedMessageBO routeQueue);

    PersistedMessageBO save(PersistedMessageBO routeQueue);

    List<PersistedMessageBO> findAll(int maxRows);

    /**
     * Finds the PersistedMessageBO identified by the passed-in primary key, if one is
     * available, otherwise returns a null object.
     * 
     * @param routeQueueId The primary key routeQueueId of the message desired.
     * @return A populated PersistedMessageBO instance, if the routeQueueId exists, otherwise
     *         a null object.
     */
    PersistedMessageBO findByRouteQueueId(Long routeQueueId);

    /**
     * Returns a List of RouteQueue documents which are queued for routing.  Will not
     * return more RouteQueues than the value of maxDocuments.
     */
    List<PersistedMessageBO> getNextDocuments(Integer maxDocuments);

    /**
     * Finds the persisted messages that match the values passed into the 
     * criteriaValues Map, with an auto-wildcard function, if no wildcard 
     * is passed in.
     * 
     * @param criteriaValues A Map of Key/Value pairs, where the Key is a string holding the field 
     *                       name, and the Value is a string holding the value to match.
     * @param maxRows the maximum number of rows to return from the query.  If -1, then all rows will be returned.
     * @return A populated (or empty) list containing the results of the search.  If no matches are made, 
     *         an empty list will be returned.
     */
    List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows);
}
