/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.impl.registry;

import org.kuali.rice.core.api.mo.ModelObjectBasic;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.ksb.api.registry.ServiceDescriptor;
import org.kuali.rice.ksb.api.registry.ServiceDescriptorContract;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;

@Entity
@Table(name="KRSB_SVC_DSCRPTR_T")
public class ServiceDescriptorBo implements ServiceDescriptorContract, ModelObjectBasic {

    @Id
    @GeneratedValue(generator = "KRSB_SVC_DSCRPTR_S")
    @PortableSequenceGenerator(name = "KRSB_SVC_DSCRPTR_S")
    @Column(name="SVC_DSCRPTR_ID")
	private String id;
	
	@Lob
	@Column(name="DSCRPTR", length = 4000)
	private String descriptor;

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescriptor() {
        return descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Long getVersionNumber() {
        return null;
    }

    public static ServiceDescriptor to(ServiceDescriptorBo bo) {
		if (bo == null) {
			return null;
		}
		return ServiceDescriptor.Builder.create(bo).build();
	}
	
	public static ServiceDescriptorBo from(ServiceDescriptor im) {
		if (im == null) {
			return null;
		}

		ServiceDescriptorBo bo = new ServiceDescriptorBo();
		bo.id = im.getId();
		bo.descriptor = im.getDescriptor();

		return bo;
	}

}
