/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceBusAdminService;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.web.KSBAction;
import org.kuali.rice.ksb.messaging.web.ServiceBusForm;

public class ServiceBusAction
extends KSBAction {
    private static final QName SERVICE_BUS_ADMIN_SERVICE_QUEUE = new QName("http://rice.kuali.org/ksb/v2_0", "serviceBusAdminService");
    private static final Logger LOG = LogManager.getLogger(ServiceBusAction.class);

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return mapping.findForward("basic");
    }

    public ActionForward refreshServiceBus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String applicationId = ConfigContext.getCurrentContextConfig().getProperty("application.id");
        List endpoints = KsbApiServiceLocator.getServiceBus().getEndpoints(SERVICE_BUS_ADMIN_SERVICE_QUEUE, applicationId);
        if (endpoints.isEmpty()) {
            KsbApiServiceLocator.getServiceBus().synchronize();
        } else {
            for (Endpoint endpoint : endpoints) {
                ServiceBusAdminService serviceBusAdminService = (ServiceBusAdminService)endpoint.getService();
                LOG.info("Calling " + endpoint.getServiceConfiguration().getEndpointUrl() + " on " + endpoint.getServiceConfiguration().getInstanceId());
                serviceBusAdminService.clearServiceBusCache();
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm actionForm) throws Exception {
        ServiceBusForm form = (ServiceBusForm)actionForm;
        form.setMyIpAddress(RiceUtilities.getIpNumber());
        form.setMyApplicationId(CoreConfigHelper.getApplicationId());
        form.setDevMode(ConfigContext.getCurrentContextConfig().getDevMode());
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        form.setMyInstanceId(serviceBus.getInstanceId());
        form.setPublishedServices(this.getPublishedServices(serviceBus));
        form.setGlobalServices(this.getGlobalServices(serviceBus));
        return null;
    }

    private List<ServiceConfiguration> getPublishedServices(ServiceBus serviceBus) {
        Map localEndpoints = serviceBus.getLocalEndpoints();
        ArrayList<ServiceConfiguration> publishedServices = new ArrayList<ServiceConfiguration>();
        for (Endpoint endpoint : localEndpoints.values()) {
            publishedServices.add(endpoint.getServiceConfiguration());
        }
        return publishedServices;
    }

    private List<ServiceConfiguration> getGlobalServices(ServiceBus serviceBus) {
        ArrayList<ServiceConfiguration> allServices = new ArrayList<ServiceConfiguration>();
        for (Endpoint endpoint : serviceBus.getAllEndpoints()) {
            allServices.add(endpoint.getServiceConfiguration());
        }
        return allServices;
    }
}

