/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api.postalcode;

import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * This is the contract for a Postal Code.  A postal code is assigned to different geographic regions
 * in order to give each region an identifier.
 *
 * Examples of postal codes are Zip Codes in the United States and FSALDU in Canada.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface PostalCodeContract extends Versioned, Inactivatable, Coded {

    /**
     * This the postal country code for the PostalCode.  This cannot be null or a blank string.
     *
     * @return postal country code
     */
    String getCountryCode();

    /**
     * This the postal state code for the PostalCode.  This can be null.
     *
     * @return postal state code
     */
    String getStateCode();

    /**
     * This the postal state code for the PostalCode.  This can be null.
     *
     * @return postal state code
     */
    String getCityName();

    /**
     * This the county code for the PostalCode.  This cannot be null.
     *
     * @return postal state code
     */
    String getCountyCode();
}
