/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.api.postalcode;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.location.api.postalcode.PostalCodeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="postalCode")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="PostalCodeType", propOrder={"code", "cityName", "countryCode", "stateCode", "active", "countyCode", "versionNumber", "_futureElements"})
public final class PostalCode
extends AbstractDataTransferObject
implements PostalCodeContract {
    private static final long serialVersionUID = 6097498602725305353L;
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="cityName", required=false)
    private final String cityName;
    @XmlElement(name="countryCode", required=true)
    private final String countryCode;
    @XmlElement(name="stateCode", required=false)
    private final String stateCode;
    @XmlElement(name="countyCode", required=false)
    private final String countyCode;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private PostalCode() {
        this.code = null;
        this.cityName = null;
        this.countryCode = null;
        this.stateCode = null;
        this.countyCode = null;
        this.active = false;
        this.versionNumber = null;
    }

    private PostalCode(Builder builder) {
        this.code = builder.getCode();
        this.cityName = builder.getCityName();
        this.countryCode = builder.getCountryCode();
        this.stateCode = builder.getStateCode();
        this.countyCode = builder.getCountyCode();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getCityName() {
        return this.cityName;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getStateCode() {
        return this.stateCode;
    }

    @Override
    public String getCountyCode() {
        return this.countyCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Builder
    implements PostalCodeContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 7077484401017765844L;
        private String code;
        private String cityName;
        private String countryCode;
        private String stateCode;
        private String countyCode;
        private boolean active;
        private Long versionNumber;

        private Builder(String code, String countryCode) {
            this.setCode(code);
            this.setCountryCode(countryCode);
        }

        public static Builder create(String code, String countryCode) {
            Builder builder = new Builder(code, countryCode);
            builder.setActive(true);
            return builder;
        }

        public static Builder create(PostalCodeContract contract) {
            Builder builder = new Builder(contract.getCode(), contract.getCountryCode());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            if (StringUtils.isNotBlank((String)contract.getCountyCode())) {
                builder.setCountyCode(contract.getCountyCode());
            }
            if (StringUtils.isNotBlank((String)contract.getCityName())) {
                builder.setCityName(contract.getCityName());
            }
            if (StringUtils.isNotBlank((String)contract.getStateCode())) {
                builder.setStateCode(contract.getStateCode());
            }
            return builder;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("code is blank");
            }
            this.code = code;
        }

        @Override
        public String getCityName() {
            return this.cityName;
        }

        public void setCityName(String cityName) {
            if (StringUtils.isBlank((String)cityName)) {
                throw new IllegalArgumentException("cityName is blank");
            }
            this.cityName = cityName;
        }

        @Override
        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            if (StringUtils.isBlank((String)countryCode)) {
                throw new IllegalArgumentException("countryCode is blank");
            }
            this.countryCode = countryCode;
        }

        @Override
        public String getStateCode() {
            return this.stateCode;
        }

        public void setStateCode(String stateCode) {
            if (StringUtils.isBlank((String)stateCode)) {
                throw new IllegalArgumentException("stateCode is blank");
            }
            this.stateCode = stateCode;
        }

        @Override
        public String getCountyCode() {
            return this.countyCode;
        }

        public void setCountyCode(String countyCode) {
            if (StringUtils.isBlank((String)countyCode)) {
                throw new IllegalArgumentException("countyCode is blank");
            }
            this.countyCode = countyCode;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public PostalCode build() {
            return new PostalCode(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/location/v2_0/PostalCodeType";
    }

    static class Elements {
        static final String CODE = "code";
        static final String CITY_NAME = "cityName";
        static final String COUNTRY_CODE = "countryCode";
        static final String STATE_CODE = "stateCode";
        static final String COUNTY_CODE = "countyCode";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "postalCode";
        static final String TYPE_NAME = "PostalCodeType";

        Constants() {
        }
    }
}

