/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api.campus;

import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * <p>CampusTypeContract interface.</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CampusTypeContract extends Versioned, GloballyUnique, Inactivatable, Coded {
	
	/**
	 * This is the name for the CampusType.
	 *
	 * <p>
	 * It is a name a campus type.
	 * </p>
	 *
	 * @return name for CampusType.
	 */
	String getName();
}
