/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.campus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusContract;
import org.kuali.rice.location.api.campus.CampusQueryResults;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.campus.CampusType;
import org.kuali.rice.location.api.campus.CampusTypeContract;
import org.kuali.rice.location.api.campus.CampusTypeQueryResults;
import org.kuali.rice.location.impl.campus.CampusBo;
import org.kuali.rice.location.impl.campus.CampusTypeBo;
import org.springframework.beans.factory.annotation.Required;

public class CampusServiceImpl
implements CampusService {
    private DataObjectService dataObjectService;

    public Campus getCampus(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is blank");
        }
        CampusBo campusBo = (CampusBo)((Object)this.getDataObjectService().find(CampusBo.class, (Object)code));
        return CampusBo.to(campusBo);
    }

    public List<Campus> findAllCampuses() {
        QueryByCriteria qbc = QueryByCriteria.Builder.forAttribute((String)"active", (Object)true).build();
        QueryResults campusBos = this.getDataObjectService().findMatching(CampusBo.class, qbc);
        return this.convertListOfCampusBosToImmutables(campusBos.getResults());
    }

    public CampusType getCampusType(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is blank");
        }
        CampusTypeBo campusTypeBo = (CampusTypeBo)((Object)this.dataObjectService.find(CampusTypeBo.class, (Object)code));
        return CampusTypeBo.to(campusTypeBo);
    }

    public List<CampusType> findAllCampusTypes() {
        QueryByCriteria qbc = QueryByCriteria.Builder.forAttribute((String)"active", (Object)true).build();
        QueryResults campusTypeBos = this.dataObjectService.findMatching(CampusTypeBo.class, qbc);
        return this.convertListOfCampusTypesBosToImmutables(campusTypeBos.getResults());
    }

    public CampusQueryResults findCampuses(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.dataObjectService.findMatching(CampusBo.class, queryByCriteria);
        CampusQueryResults.Builder builder = CampusQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Campus.Builder> ims = new ArrayList<Campus.Builder>();
        for (CampusBo bo : results.getResults()) {
            ims.add(Campus.Builder.create((CampusContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public CampusTypeQueryResults findCampusTypes(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "query");
        QueryResults results = this.dataObjectService.findMatching(CampusTypeBo.class, queryByCriteria);
        CampusTypeQueryResults.Builder builder = CampusTypeQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<CampusType.Builder> ims = new ArrayList<CampusType.Builder>();
        for (CampusTypeBo bo : results.getResults()) {
            ims.add(CampusType.Builder.create((CampusTypeContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    private List<Campus> convertListOfCampusBosToImmutables(List<CampusBo> campusBos) {
        ArrayList<Campus> campuses = new ArrayList<Campus>();
        for (CampusBo bo : campusBos) {
            Campus campus = CampusBo.to(bo);
            campuses.add(campus);
        }
        return Collections.unmodifiableList(campuses);
    }

    private List<CampusType> convertListOfCampusTypesBosToImmutables(List<CampusTypeBo> campusTypeBos) {
        ArrayList<CampusType> campusTypes = new ArrayList<CampusType>();
        for (CampusTypeBo bo : campusTypeBos) {
            CampusType campusType = CampusTypeBo.to(bo);
            campusTypes.add(campusType);
        }
        return Collections.unmodifiableList(campusTypes);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

