/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.impl.county;

import org.kuali.rice.krad.data.jpa.IdClassBase;

public class CountyId extends IdClassBase {

    private static final long serialVersionUID = 7565812479232764845L;

    private String code;
    private String countryCode;
    private String stateCode;

    public CountyId() {}

    public CountyId(String code, String countryCode, String stateCode) {
        this.code = code;
        this.countryCode = countryCode;
        this.stateCode = stateCode;
    }

    public String getCode() {
        return code;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public String getStateCode() {
        return stateCode;
    }

}

