/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.impl.campus;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kns.kim.role.RoleTypeServiceBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CampusRoleTypeServiceImpl extends RoleTypeServiceBase {

    @Override
    protected List<String> getRequiredAttributes() {
        final List<String> attrs = new ArrayList<String>(super.getRequiredAttributes());
        attrs.add(KimConstants.AttributeConstants.CAMPUS_CODE);
        return Collections.unmodifiableList(attrs);
    }

    @Override
    public List<String> getWorkflowRoutingAttributes(String routeLevel) {
        if (StringUtils.isBlank(routeLevel)) {
            throw new RiceIllegalArgumentException("routeLevel was blank or null");
        }

        final List<String> attrs = new ArrayList<String>(super.getWorkflowRoutingAttributes(routeLevel));
        attrs.add(KimConstants.AttributeConstants.CAMPUS_CODE);
        return Collections.unmodifiableList(attrs);
    }

	@Override
	public List<KimAttributeField> getAttributeDefinitions(String kimTypeId) {
		if (StringUtils.isBlank(kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }

        List<KimAttributeField> map = new ArrayList<KimAttributeField>(super.getAttributeDefinitions(kimTypeId));

		for (int i = 0; i < map.size(); i++) {
            final KimAttributeField definition = map.get(i);
			if (KimConstants.AttributeConstants.CAMPUS_CODE.equals(definition.getAttributeField().getName())) {
				KimAttributeField.Builder b = KimAttributeField.Builder.create(definition);

                RemotableAttributeField.Builder fb =  b.getAttributeField();
                fb.setRequired(true);

                b.setAttributeField(fb);
                map.set(i, b.build());
			}
		}
		return Collections.unmodifiableList(map);
	}
}
