<#--
 #%L
 %%
 Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#macro uif_viewHeader element>

    <#-- Return if all content is missing -->
    <#if (!element.headerText?? || !element.headerText?has_content || element.headerText == '&nbsp;')
        && !element.richHeaderMessage?? && !element.upperGroup??
        && !element.lowerGroup?? && !element.rightGroup??
        && (!element.supportTitleMessage?? || !element.supportTitleMessage.messageText?has_content)
        && (!element.areaTitleMessage?? || !element.areaTitleMessage.messageText?has_content)
        && (!element.metadataMessage?? || !element.metadataMessage.messageText?has_content)>
        <#return>
    </#if>

    <#if element.headerStyleClassesAsString?has_content>
        <#local styleClass="class=\"${element.headerStyleClassesAsString}\""/>
    </#if>

    <#if element.headerTagStyle?has_content>
        <#local style="style=\"${element.headerTagStyle}\""/>
    </#if>

    <#if element.headerLevel?has_content>
        <#local headerOpenTag="<${element.headerLevel} id=\"${element.id?replace(\"_headerWrapper\", \"\")}_header\" ${style!} ${styleClass!}>"/>
        <#local headerCloseTag="</${element.headerLevel}>"/>
    </#if>

        <#-- Main header content -->
        <@krad.wrap renderAs="header" component=element>

            <#if element.headerLevel?has_content && element.headerText?has_content && element.headerText != '&nbsp;'>

                <@krad.template component=element.upperGroup/>

                <#if element.rightGroup?has_content && element.rightGroup.render && element.upperGroup?has_content
                    && element.upperGroup.render>
                    <div class="uif-header-inner">
                </#if>

                ${headerOpenTag}

                    <#if element.areaTitleMessage?has_content && element.areaTitleMessage.messageText?has_content>
                        <@krad.template component=element.areaTitleMessage/>
                    </#if>

                    <span class="uif-headerText-span">
                        <#-- rich message support -->
                        <#if element.richHeaderMessage?has_content>
                            <@krad.template component=element.richHeaderMessage/>
                        <#else>
                        ${element.headerText}
                        </#if>
                    </span>

                    <#if element.context['parent']?has_content>
                        <#local group=element.context['parent']/>
                        <@krad.template component=group.help/>
                    </#if>

                    <#if element.supportTitleMessage?has_content && element.supportTitleMessage.messageText?has_content
                        && element.supportTitleMessage.messageText != '&nbsp;'>
                        <span class="uif-supportTitle-wrapper">
                            <@krad.template component=element.supportTitleMessage/>
                        </span>
                    </#if>

                ${headerCloseTag}

                <#if element.metadataMessage?has_content && element.metadataMessage.messageText?has_content>
                    <@krad.template component=element.metadataMessage/>
                </#if>

                <#-- right group -->
                <@krad.template component=element.rightGroup/>

                <#if element.rightGroup?has_content && element.rightGroup.render && element.upperGroup?has_content
                    && element.upperGroup.render>
                    </div>
                </#if>

                <@krad.template component=element.lowerGroup/>

            </#if>

        </@krad.wrap>

</#macro>
