<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ page import="java.util.List" %>
<%@ page import="java.util.Iterator" %>


<kul:page docTitle="Ingester" headerMenuBar=""
	headerTitle="Ingester" transactionalDocument="" htmlFormAction="Ingester" renderMultipart="true" lookup="true"
	>

<div id="headerarea-small" class="headerarea-small">
<h1>Ingester</h1>
</div>

<div class="error">

<input class="tinybutton" name="methodToCall.search" src="images/pixel_clear.gif" type="image" border="0" height="0" width="0">

<c:if test="${messages != null}">
  <ul>
    <c:forEach var="message" items="${messages}" >
      <li>
  	    <!-- pre makes stack traces, etc. format correctly -->
        <pre><c:out value="${message}"/></pre>
      </li>
    </c:forEach>
  </ul>
</c:if>

<kul:errors displayRemaining="true"
	errorTitle="Other errors:"
	warningTitle="Other warnings:"
	infoTitle="Other informational messages:"/>

</div>
<div>
<br><br>

	<table class="datatable-center" style="margin-left: auto; margin-right: auto" cellspacing="0" cellpadding="0"
		align="center">
		<tbody>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[0]">XML File:</label></th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[0]" styleId="file[0]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[1]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[1]" styleId="file[1]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[2]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[2]" styleId="file[2]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[3]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[3]" styleId="file[3]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[4]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[4]" styleId="file[4]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[5]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[5]" styleId="file[5]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[6]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[6]" styleId="file[6]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[7]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[7]" styleId="file[7]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[8]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[8]" styleId="file[8]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr>
				<th class="grid" width="Infinity%" align="right">
					<label for="file[9]">XML File:</label>
				</th>
				<td class="grid" width="Infinity%">
				&nbsp;<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[9]" styleId="file[9]" title="XML File"/>&nbsp;
				</td>
			</tr>
			<tr align="center">
				<td class="infoline" height="30" colspan="2">
				<div align="center"><html-el:image
					src="images/buttonsmall_uploadxml.gif" value="Upload XML data"
					border="0" styleClass="tinybutton" styleId="imageField" /></div>
				</td>
			</tr>
		</tbody>
	</table>

</div>

  <c:if test="${!empty UserSession && UserSession.productionEnvironment}">
    <script type="text/javascript">
      jQuery(function() {
        alert('<bean:message key="ingester.alert.initial" />');
        jQuery('#kualiForm').submit(function() {
          var bool = confirm('<bean:message key="ingester.alert.onsubmit" />');
          excludeSubmitRestriction = !bool;
          return bool;
        });
        excludeSubmitRestriction = true;
      });
    </script>
  </c:if>
</kul:page>
