<#--
 #%L
 %%
 Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    HTML Link to Submit Form Via JavaScript

 -->

<#macro uif_actionLink element>

    <#if element.navigateToPageId?has_content>
        <#local pound="#"/>
        <#local href="href=\"${pound}${element.navigateToPageId}\""/>
        <#local name="name=\"${element.navigateToPageId}\""/>
    </#if>

    <#if element.skipInTabOrder>
        <#local tabindex="tabindex=-1"/>
    <#else>
        <#local tabindex="tabindex=0"/>
    </#if>

    <#if !element.actionLabel??>
        <#local imageRole="role='presentation'"/>
    </#if>

    <#if element.actionImage??>
        <#if element.actionImage.height?has_content>
            <#local height="height='${element.actionImage.height}'"/>
        </#if>

        <#if element.actionImage.width?has_content>
            <#local width="width='${element.actionImage.width}'"/>
        </#if>
    </#if>

    <#local imagePlacement="${element.actionImagePlacement}"/>

    <#local actionLabel="${element.actionLabel!}"/>
    <#if element.renderInnerTextSpan>
        <#local actionLabel="<span class=\"uif-innerText\">${element.actionLabel!}</span>"/>
    </#if>

    <#local label="${element.actionLabel!}"/>
    <#if !label?has_content>
        <#local label="${element.title!}"/>
    </#if>

    <#if !label?has_content && element.iconClass??>
        <#if element.iconClass?contains("icon-info")>
            <#local label="Information"/>
        <#elseif element.iconClass?contains("icon-question") || element.iconClass?contains("icon-help")>
            <#local label="Help"/>
        </#if>
    </#if>

    <#if element.iconClass??>
        <#if element.actionIconPlacement == 'ICON_ONLY'>
            <#-- no span necessary, icon class is on the link -->
            <a id="${element.id}" ${href!} ${name!} ${krad.attrBuild(element)}
            ${tabindex} role="button" aria-label="${label}" ${element.simpleDataAttributes!}></a>
        <#elseif element.actionIconPlacement == 'LEFT'>
        <a id="${element.id}" ${href!} ${name!} ${krad.attrBuild(element)}
        ${tabindex} role="button" aria-label="${label}" ${element.simpleDataAttributes!}><span class="${element.iconClass}"></span>${actionLabel}</a>
        <#elseif element.actionIconPlacement == 'RIGHT'>
        <a id="${element.id}" ${href!} ${name!} ${krad.attrBuild(element)}
        ${tabindex} role="button" aria-label="${label}" ${element.simpleDataAttributes!}>${actionLabel}<span class="${element.iconClass}"></span></a>
        </#if>
    <#else>

        <a id="${element.id}" ${href!} ${name!} ${krad.attrBuild(element)}
        ${tabindex} role="button" aria-label="${label}" ${element.simpleDataAttributes!}>

            <#if element.actionImage?? && element.actionImage.render && imagePlacement?has_content>
                <#if imagePlacement == 'RIGHT'>
                    <#local imageStyleClass="rightActionImage"/>
                <#elseif imagePlacement == 'LEFT'>
                    <#local imageStyleClass="leftActionImage"/>
                </#if>

                <#local imageTag>
                    <img ${imageRole!} ${height!} ${width!}
                            style="${element.actionImage.style!}"
                            class="actionImage ${imageStyleClass!} ${element.actionImage.styleClassesAsString!}"
                            src="${element.actionImage.source!}"
                            alt="${element.actionImage.altText!}"
                            title="${element.actionImage.title!}"/>
                </#local>

                <#if imagePlacement == 'RIGHT'>
                ${actionLabel!}${imageTag}
                <#elseif imagePlacement == 'LEFT'>
                ${imageTag}${actionLabel!}
                <#elseif imagePlacement == 'IMAGE_ONLY'>
                ${imageTag}
                <#else>
                ${actionLabel!}
                </#if>
            <#else>
            ${actionLabel!}
            </#if>

        </a>
    </#if>

    <@krad.disable control=element type="actionLink"/>

    <#-- render confirmation dialog for action -->
    <@krad.template component=element.confirmationDialog/>

</#macro>
