/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.common;

import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.testtools.common.PropertiesUtils;

public class PropertiesUtilsTest {
    private static final String JIRA_AWARE_CONTAINS_FAILURES_PROPERTIES = "JiraAwareContainsFailures.properties";
    private static final String PATH_TO_TEST_PROPERTIES_FILE = "org/kuali/rice/testtools/common/PropertiesUtilsTest.properties";
    private static final String PROPERTIES_DIR_INTELLIJ = "rice-tools-test/src/main/resources/";
    private static final String PROPERTIES_DIR_MAVEN = "src/main/resources/";
    private static final String PROPERTY_DOESNT_EXIST_IN_FILE = "PROPERTY_DOESNT_EXIST_IN_FILE";
    private static final String REMOTE_DRIVER_SAUCELABS_PROPERTY = "remote.driver.saucelabs";
    protected static PropertiesUtils propUtils;

    @BeforeClass
    public static void setUp() {
        System.setProperty(REMOTE_DRIVER_SAUCELABS_PROPERTY, "true");
        System.setProperty(PROPERTY_DOESNT_EXIST_IN_FILE, "true");
        propUtils = new PropertiesUtils();
    }

    private void assertPropertiesKeysCountNotZero(Properties props) {
        Assert.assertTrue((props.keySet().size() > 0 ? 1 : 0) != 0);
    }

    private void assertProperityDoesntExistInFilePropertyTrue(Properties props) {
        Assert.assertTrue((boolean)props.getProperty(REMOTE_DRIVER_SAUCELABS_PROPERTY).equals("true"));
    }

    private void assertRemoteDriverSaucelabsPropertyTrue(Properties props) {
        Assert.assertTrue((boolean)props.getProperty(REMOTE_DRIVER_SAUCELABS_PROPERTY).equals("true"));
    }

    private static void printSystemProperties() {
        for (String key : System.getProperties().stringPropertyNames()) {
            System.out.println(key + " = " + System.getProperty(key));
        }
    }

    @Test
    public void testLoadPropertiesResource() throws IOException {
        Properties props = propUtils.loadProperties(null, JIRA_AWARE_CONTAINS_FAILURES_PROPERTIES);
        this.assertPropertiesKeysCountNotZero(props);
    }

    @Test
    public void testLoadPropertiesFile() throws IOException {
        Properties props = propUtils.loadProperties("rice-tools-test/src/main/resources/JiraAwareContainsFailures.properties", null);
        if (props == null) {
            props = propUtils.loadProperties("src/main/resources/JiraAwareContainsFailures.properties", null);
        }
        Assert.assertNotNull((Object)props);
        this.assertPropertiesKeysCountNotZero(props);
    }

    @Test
    public void testLoadProperties() throws IOException {
        Properties props = propUtils.loadProperties(null, PATH_TO_TEST_PROPERTIES_FILE);
        this.assertPropertiesKeysCountNotZero(props);
        Assert.assertTrue((boolean)props.keySet().contains(REMOTE_DRIVER_SAUCELABS_PROPERTY));
        Assert.assertTrue((boolean)props.getProperty(REMOTE_DRIVER_SAUCELABS_PROPERTY).equals(""));
    }

    @Test
    public void testSystemPropertiesOverrides() throws IOException {
        this.assertProperityDoesntExistInFilePropertyTrue(System.getProperties());
        this.assertRemoteDriverSaucelabsPropertyTrue(System.getProperties());
        Properties props = propUtils.loadPropertiesWithSystemOverrides(PATH_TO_TEST_PROPERTIES_FILE);
        this.assertPropertiesKeysCountNotZero(props);
        this.assertRemoteDriverSaucelabsPropertyTrue(props);
        Assert.assertFalse((boolean)props.containsKey(PROPERTY_DOESNT_EXIST_IN_FILE));
    }

    @Test
    public void testSystemPropertiesAndOverrides() throws IOException {
        this.assertProperityDoesntExistInFilePropertyTrue(System.getProperties());
        this.assertRemoteDriverSaucelabsPropertyTrue(System.getProperties());
        Properties props = propUtils.loadPropertiesWithSystemAndOverrides(PATH_TO_TEST_PROPERTIES_FILE);
        this.assertPropertiesKeysCountNotZero(props);
        this.assertRemoteDriverSaucelabsPropertyTrue(props);
        this.assertProperityDoesntExistInFilePropertyTrue(props);
    }

    @Test
    public void testLoadPropertiesWithSystemAndOverridesIntoSystem() throws IOException {
        Assert.assertNull((Object)System.getProperty("saucelabs.browser"));
        this.assertRemoteDriverSaucelabsPropertyTrue(System.getProperties());
        Properties props = propUtils.loadPropertiesWithSystemAndOverridesIntoSystem(PATH_TO_TEST_PROPERTIES_FILE);
        Assert.assertTrue((boolean)System.getProperty("saucelabs.browser").equals("ff"));
    }
}

