/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import org.kuali.rice.testtools.common.JiraAwareFailable;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.WebDriver;

public class JiraAwareWebDriverUtils {
    public static void assertFalse(boolean booleanToAssertFalse, JiraAwareFailable failable) {
        if (booleanToAssertFalse) {
            failable.jiraAwareFail("expected false, but was true");
        }
    }

    public static void assertFalse(String message, boolean booleanToAssertFalse, JiraAwareFailable failable) {
        if (booleanToAssertFalse) {
            failable.jiraAwareFail(message + " expected false, but was true");
        }
    }

    public static void assertTrue(boolean booleanToAssertTrue, JiraAwareFailable failable) {
        if (!booleanToAssertTrue) {
            failable.jiraAwareFail("expected true, but was false");
        }
    }

    public static void assertTrue(String message, boolean booleanToAssertTrue, JiraAwareFailable failable) {
        if (!booleanToAssertTrue) {
            failable.jiraAwareFail(message + " expected true, but was false");
        }
    }

    public static void assertButtonDisabledByText(WebDriver driver, String buttonText, JiraAwareFailable failable) {
        WebDriverUtils.jGrowl(driver, "Assert", false, "Assert " + buttonText + " button is disabled");
        if (WebDriverUtils.findButtonByText(driver, buttonText).isEnabled()) {
            failable.jiraAwareFail(buttonText + " button is not disabled");
        }
    }

    public static void assertButtonEnabledByText(WebDriver driver, String buttonText, JiraAwareFailable failable) {
        WebDriverUtils.jGrowl(driver, "Assert", false, "Assert " + buttonText + " button is enabled");
        if (!WebDriverUtils.findButtonByText(driver, buttonText).isEnabled()) {
            failable.jiraAwareFail(buttonText + " button is not enabled");
        }
    }
}

